/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListSearchManager;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionRenderingDebugger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class EntryListWidget
extends WidgetWithBounds
implements OverlayListWidget,
DraggableStackVisitorWidget {
    private static final int SIZE = 18;
    protected final RegionRenderingDebugger debugger = new RegionRenderingDebugger();
    protected Rectangle bounds;
    protected Rectangle innerBounds;
    public final NumberAnimator<Double> scaleIndicator = ValueAnimator.ofDouble((double)0.0).withConvention(() -> 0.0, 8000L);

    public static int entrySize() {
        return Mth.m_14165_((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    public static boolean notSteppingOnExclusionZones(int left, int top, int width, int height) {
        Minecraft instance = Minecraft.m_91087_();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.f_91080_)) {
            InteractionResult fit = EntryListWidget.canItemSlotWidgetFit(left, top, width, height, decider);
            if (fit == InteractionResult.PASS) continue;
            return fit == InteractionResult.SUCCESS;
        }
        return true;
    }

    private static InteractionResult canItemSlotWidgetFit(int left, int top, int width, int height, OverlayDecider decider) {
        InteractionResult fit = decider.isInZone(left, top);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left, top + height);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top + height);
        return fit;
    }

    private boolean containsChecked(Point point, boolean inner) {
        return this.containsChecked(point.x, point.y, inner);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && super.containsMouse(mouseX, mouseY);
    }

    public boolean innerContainsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && this.innerBounds.contains(mouseX, mouseY);
    }

    public boolean containsChecked(double x, double y, boolean inner) {
        if (inner ? !this.innerContainsMouse(x, y) : !this.containsMouse(x, y)) {
            return false;
        }
        Minecraft instance = Minecraft.m_91087_();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.f_91080_)) {
            InteractionResult result = decider.isInZone(x, y);
            if (result == InteractionResult.PASS) continue;
            return result == InteractionResult.SUCCESS;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        bounds = bounds.clone();
        int heightReduction = (int)Math.round((double)bounds.height * (1.0 - ConfigObject.getInstance().getVerticalEntriesBoundariesPercentage()));
        bounds.y += heightReduction / 2;
        bounds.height -= heightReduction;
        int maxHeight = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getVerticalEntriesBoundariesRows());
        if (bounds.height > maxHeight) {
            bounds.y += (bounds.height - maxHeight) / 2;
            bounds.height = maxHeight;
        }
        int entrySize = EntryListWidget.entrySize();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(Mth.m_14143_((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        int width = Math.max(Mth.m_14143_((float)((float)(bounds.width - 2) / (float)entrySize)), 1);
        int height = Math.max(Mth.m_14143_((float)((float)(bounds.height - 2) / (float)entrySize)), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)entrySize / 2.0f)), width * entrySize, height * entrySize);
    }

    @Override
    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
        if (this.innerBounds.contains(context.getCurrentPosition())) {
            context.renderToVoid(stack);
            return DraggedAcceptorResult.CONSUMED;
        }
        return DraggedAcceptorResult.PASS;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.containsChecked(mouseX, mouseY, false) && Screen.m_96637_()) {
            ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
            this.scaleIndicator.setAs(10.0);
            if (config.setEntrySize(config.getEntrySize() + amount * 0.075)) {
                ConfigManager.getInstance().saveConfig();
                REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (!this.hasSpace()) {
            return;
        }
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        this.renderEntries(fastEntryRendering, matrices, mouseX, mouseY, delta);
        this.debugger.render(matrices, this.bounds.x, this.bounds.y, delta);
        if (this.containsChecked(mouseX, mouseY, false) && ClientHelper.getInstance().isCheating() && !(Minecraft.m_91087_().f_91080_ instanceof DisplayScreen) && !this.minecraft.f_91074_.f_36096_.m_142621_().m_41619_() && ClientHelperImpl.getInstance().canDeleteItems()) {
            EntryStack<ItemStack> stack = EntryStacks.of(this.minecraft.f_91074_.f_36096_.m_142621_().m_41777_());
            if (stack.getType() != VanillaEntryTypes.ITEM) {
                EntryStack<ItemStack> cheatsAs = stack.cheatsAs();
                stack = cheatsAs.isEmpty() ? stack : cheatsAs;
            }
            for (Widget widget : this.m_6702_()) {
                EntryWidget widget2;
                if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !(widget2 = (EntryWidget)widget).cancelDeleteItems(stack)) continue;
                return;
            }
            Tooltip.create(new Component[]{new TranslatableComponent("text.rei.delete_items")}).queue();
        }
        this.scaleIndicator.update((double)delta);
        if ((Double)this.scaleIndicator.value() > 0.04) {
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 500.0);
            TextComponent component = new TextComponent(Math.round(ConfigObject.getInstance().getEntrySize() * 100.0) + "%");
            int width = this.font.m_92852_((FormattedText)component);
            int n = (int)Math.round(160.0 * Mth.m_14008_((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            int textColor = (int)Math.round(221.0 * Mth.m_14008_((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            this.m_93179_(matrices, this.bounds.getCenterX() - width / 2 - 2, this.bounds.getCenterY() - 6, this.bounds.getCenterX() + width / 2 + 2, this.bounds.getCenterY() + 6, n, n);
            this.font.m_92889_(matrices, (Component)component, (float)(this.bounds.getCenterX() - width / 2), (float)(this.bounds.getCenterY() - 4), 0xFFFFFF | textColor);
            matrices.m_85849_();
        }
    }

    protected abstract void renderEntries(boolean var1, PoseStack var2, int var3, int var4, float var5);

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.containsChecked(EntryListWidget.mouse(), false)) {
            for (Widget widget : this.getEntryWidgets()) {
                if (!widget.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(Rectangle bounds, String searchTerm) {
        this.bounds = REIRuntime.getInstance().calculateEntryListArea(bounds);
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(searchTerm);
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && favoritesListWidget == null) {
            this.updateSearch(searchTerm, true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean hasSpace() {
        int height;
        int entrySize = EntryListWidget.entrySize();
        int width = this.innerBounds.width / entrySize;
        return width * (height = this.innerBounds.height / entrySize) > 0;
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        boolean zoomed = ConfigObject.getInstance().isFocusModeZoomed();
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        this.updateEntries(entrySize, zoomed);
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.getSystemRegion().updateEntriesPosition(entry -> true);
            favoritesListWidget.getRegion().updateEntriesPosition(entry -> true);
        }
    }

    protected abstract void updateEntries(int var1, boolean var2);

    public abstract boolean isEmpty();

    protected abstract void setCollapsedStacks(List<Object> var1);

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        EntryListSearchManager.INSTANCE.update(searchTerm, ignoreLastSearch, stacks -> {
            this.setCollapsedStacks((List<Object>)stacks);
            this.updateEntriesPosition();
        });
        this.debugger.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favorites = ScreenOverlayImpl.getFavoritesListWidget();
        if (favorites != null) {
            favorites.updateSearch();
        }
    }

    public List<? extends Widget> m_6702_() {
        return this.getEntryWidgets();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.hasSpace()) {
            return false;
        }
        for (Widget widget : this.m_6702_()) {
            if (!widget.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.containsChecked(mouseX, mouseY, false)) {
            LocalPlayer player = this.minecraft.f_91074_;
            if (ClientHelper.getInstance().isCheating() && !(Minecraft.m_91087_().f_91080_ instanceof DisplayScreen) && player != null && player.f_36096_ != null && !player.f_36096_.m_142621_().m_41619_() && ClientHelperImpl.getInstance().canDeleteItems()) {
                boolean bl;
                EntryStack<ItemStack> stack = EntryStacks.of(this.minecraft.f_91074_.f_36096_.m_142621_().m_41777_());
                if (stack.getType() != VanillaEntryTypes.ITEM) {
                    EntryStack<ItemStack> entryStack = stack.cheatsAs();
                    stack = entryStack.isEmpty() ? stack : entryStack;
                }
                boolean bl2 = true;
                for (Widget widget : this.m_6702_()) {
                    EntryWidget widget2;
                    if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !(widget2 = (EntryWidget)widget).cancelDeleteItems(stack)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    ClientHelper.getInstance().sendDeletePacket();
                    return true;
                }
            }
            for (Widget widget : this.m_6702_()) {
                if (!widget.m_6348_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EntryStack<?> getFocusedStack() {
        Point mouse = EntryListWidget.mouse();
        if (this.containsChecked(mouse, false)) {
            for (Slot slot : this.getEntryWidgets()) {
                EntryStack<?> currentEntry = slot.getCurrentEntry();
                if (currentEntry.isEmpty() || !slot.containsMouse(mouse)) continue;
                return currentEntry.copy();
            }
        }
        return EntryStack.empty();
    }

    protected abstract List<EntryListStackEntry> getEntryWidgets();

    public void init(ScreenOverlayImpl overlay) {
    }
}

